﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Runtime.CompilerServices;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace HangMan
{
    /// <summary>
    /// Logique d'interaction pour MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window, INotifyPropertyChanged //InotifyPropertyChanged pour voir quand l'élément avec le binding doit changer
    {
        private List<char> Essais = new List<char>();
        private int NbrEssais = 0;
        private int FausseReponse = 0;

        // Contient chemin vers image pendu 
        public string ImagePendu
        {
            get
            {
                return @"/pendu/stage" + FausseReponse.ToString() + ".png";
            }
            set
            {

            }
        }

        public string EssaisUtilisateur
        {
            get
            {
                string resultat = "";
                foreach (char lettre in Essais)
                {
                    resultat += " " + lettre;
                }
                return resultat;
            }
            set
            {

            }
        }
        private string MotPendu;

        //cache les lettres non trouvées à part les symboles (' - , . : ; et les espaces)
        public string MotDuPendu
        {
            get
            {
                string resultat = "";
                char[] symbole = { '\'', '-', ':', ',', ' ' };
                foreach (char element in MotPendu)
                {
                    if (Essais.Contains(Char.ToLower(element)) || symbole.Contains(element))
                    {
                        resultat += element;
                    }
                    else
                    {
                        resultat += "*";
                    }

                }

                return resultat;
            }
            set
            {
            }
        }

        #region Lancement
        public MainWindow()
        {
            string[] MotFichiertxt = File.ReadAllLines(@"~/../../../Text/mot.txt");
            Random NombreAleatoire = new Random();
            MotPendu = MotFichiertxt[NombreAleatoire.Next(0, MotFichiertxt.Length)];
            InitializeComponent();
            DataContext = this; //utilisé avec le binding
        }
        #endregion

        private void LectureEntrée(object sender, TextChangedEventArgs e)
        {
            if (_txtbox_MotAEntrer.Text != "")
            {
                //Alerte si l'on rentre plusieurs fois la même lettre
                if (Essais.Contains(_txtbox_MotAEntrer.Text.ToLower()[0]))
                {
                    MessageBox.Show(String.Format("Vous avez déjà essayer {0}", _txtbox_MotAEntrer.Text.ToLower()));
                }
                else
                {
                    //Add entry to already entered letters and increase number of guesses
                    Essais.Add(_txtbox_MotAEntrer.Text.ToLower()[0]);
                    _lbl_lettres_entree.GetBindingExpression(Label.ContentProperty).UpdateTarget();
                    NbrEssais++;

                    //Fausse Lettre
                    if (!MotPendu.ToLower().Contains(_txtbox_MotAEntrer.Text.ToLower()[0]))
                    {
                        FausseReponse++;
                        _img_AvancementPendu.GetBindingExpression(Image.SourceProperty).UpdateTarget();
                        _img_AvancementPendu.Source = new BitmapImage(new Uri(@"/pendu/stage" + FausseReponse.ToString() + ".png", UriKind.Relative));
                    }
                }
                //Si gagné
                if (FausseReponse < 10)
                {
                    _txtbox_MotAEntrer.Clear();
                    _lbl_MotATrouver.GetBindingExpression(Label.ContentProperty).UpdateTarget();
                    if (MotPendu.ToLower() == MotDuPendu.ToLower())
                    {
                        MessageBox.Show(String.Format("Bien Joué ! Tu as trouvé {0} en {1} entrée avec {2} erreurs !", MotPendu, NbrEssais, FausseReponse));
                        this.Close();
                    }
                }
                else
                {
                    //Si Perdu
                    MessageBox.Show("Perdu !");
                    this.Close();
                }
            }

        }

        //Pour rechercher les changements dans la txtbox des lettres /utilisé de base avec les binding
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string propertyName = null)
        {
            PropertyChangedEventHandler handler = this.PropertyChanged;
            if (handler != null)
            {
                var e = new PropertyChangedEventArgs(propertyName);
                handler(this, e);
            }
        }
    }
}
